import { sha256 } from './sha256.js';
DevExpress.localization.locale("fr");

$(document).ready(function() {

    //Chargement des données stockées
    var refPage = localStorage.getItem("page");
    if (refPage == null) var refPage = "__ACCUEIL__";

    var pseudo = localStorage.getItem("pseudo");
    var mdp = localStorage.getItem("mdp");
    if ((pseudo == null) || (mdp == null)) {
        $("body").prepend(`<div class="login">
                            <div class="input-login">
                                <a href="../index.html" class="logo-login">
                                    <img width="130px" src="../images/logo_Radio-Vintage.png" alt="Radio Vintage">
                                </a>
                                <p class="logo-login" style="color: red;">Administration</p>
                            </div>
                            <div class="input-login">
                                <input id="pseudo" type="text"></input>
                                <input id="mdp" type="password"></input>
                                <input id="login" type="button" value="Connexion"></input>
                            </div>
                           </div>
                           <div class="input-login">
                            <p id="result"></p>
                           </div>`);
        function login(e) {
            e.preventDefault();
            var pseudo = $("input#pseudo").val();
            var mdp = sha256($("input#mdp").val());
            $.ajax({
                type : "POST",
                url  : "../data/data.php",
                data : { function : "checkPassword", 
                         data : { name : pseudo, pwd : mdp } },
                success: function(res){
                    if(res == 0) {
                        $("p#result").empty().show().html(`<p style="color: green;">Redirection...</p>`).delay(3000).fadeOut(300);
                        localStorage.setItem("pseudo", pseudo);
                        localStorage.setItem("mdp", mdp);
                        localStorage.setItem("page", "__ACCUEIL__");
                        location.reload();
                    }
                    else
                        $("p#result").empty().show().html(`<p style="color: red;">Pseudo ou mot de passe incorrect.</p>`).delay(3000).fadeOut(300);
                }
            });
        }
        $('input#pseudo').keyup(function(e) {
            if(e.keyCode == 13) login(e);
        });
        $('input#mdp').keyup(function(e) {
            if(e.keyCode == 13) login(e);
        });
        $("input#login").click(function(e) {
            login(e);
        });
    }
    else {
        $.ajax({
            type : "POST",
            url  : "../data/analytics.php",
            data : { admin : true }
        });
        $("body").prepend(`<header class="nav-area fixed-top">
                                <div class="main-menu">
                                    <div class="navbar navbar-cus navbar-header justify-content-center">
                                        <div class="row d-flex justify-content-center">
                                            <nav class="deconnexion">
                                                <input class="bdeconnexion" type="button" value="Déconnexion"></input>
                                            </nav>
                                            <nav class="navbar-brand">
                                                <a href="../index.html" class="img-fluid">
                                                    <img width="130px" src="../images/logo_Radio-Vintage.png" alt="Radio Vintage">
                                                </a>
                                            </nav>
                                            <nav>
                                                <a type="button" id="openBtn" class="navbar-toggle burger" href="#">
                                                    <div class="burger-center">
                                                        <span class="icon-bar"></span>
                                                        <span class="icon-bar"></span>
                                                        <span class="icon-bar"></span>
                                                    </div>
                                                </a>
                                                <div id="sidenav" class="sidenav">
                                                    <a id="closeBtn" href="#" class="close">&times;</a>
                                                    <ul class="sidenav-right">
                                                    </ul>
                                                </div>
                                                <ul class="navbar-right">
                                                </ul>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </header>
                            <div class="contenu"></div>`);
        $(`input[type="button"].bdeconnexion`).click(function(e) {
            localStorage.removeItem('pseudo');
            localStorage.removeItem('mdp');
            location.reload();
        })

        //Fonction Wait
        $.wait = function(ms) {
            var defer = $.Deferred();
            setTimeout(function() { defer.resolve(); }, ms);
            return defer;
        };

        String.prototype.hashCode = function() {
            var hash = 0, i, chr;
            if (this.length === 0) return hash;
            for (i = 0; i < this.length; i++) {
            chr   = this.charCodeAt(i);
            hash  = ((hash << 5) - hash) + chr;
            hash |= 0; // Convert to 32bit integer
            }
            return hash;
        };

        //Chargement des données
        function loadData(page) {
            $.ajax({
                type : "POST",
                url  : "../data/data.php",
                data : { function : "getDB" },
                success: function(data){

                    function loadNavbar(pages, data, admin) {
                        var ul = $("ul.sidenav-right");
                        ul.empty();
                        ul.append(`<li><a class="smooth-menu" href="__ACCUEIL__">Acceuil</a></li>`);
                        if(admin) {
                            ul.append(`<li class="titre"><p>Général</p></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__SETTINGS__">Paramètres du site</a></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__USERS__">Utilisateurs</a></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__PAGES__">Pages</a></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__NAVBAR__">Barres de Navigation</a></li>`);
                            ul.append(`<li class="titre"><p>Contenus</p></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__CAROUSELS__">Carousels</a></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__IMAGES__">Images</a></li>`);
                        }
                        else {
                            ul.append(`<li class="titre"><p>Général</p></li>`);
                            ul.append(`<li><a class="smooth-menu" href="__CNFDNCLT__">Paramètres de confidentialité</a></li>`);
                        }
                        ul.append(`<li class="titre"><p>Pages</p></li>`);
                        if(admin) {
                            ul.append(`<li><a class="smooth-menu" href="index">Page d'accueil</a></li>`);
                        }
                        for (var i = 0; i < pages.length; i++) {
                            if(pages[i] != "index")
                                ul.append($('<li><a class="smooth-menu" href="'+ pages[i] +'">'+ data.pages[pages[i]].nom +'</a></li>'));
                        }
                        setChangement();
                    }

                    //Chargement des metadatas
                    $("meta[name='description']").attr("content", data.description);
                    $("meta[name='keywords']").attr("content", data.keywords);
                    document.title = data.pages.index.nom;
                    //Chargement des liens du header
                    $.ajax({
                        type : "POST",
                        url  : "../data/data.php",
                        data : { function : "isAdmin", 
                                 data : { name : pseudo, pwd : mdp } },
                        success: function(admin){
                            if(admin) {
                                var pages = Object.keys(data.pages);
                                loadNavbar(pages, data, true);
                                //Chargement de la page
                                if(page.localeCompare("__ACCUEIL__")==0) accueil();
                                else if(page.localeCompare("__SETTINGS__")==0) settings();
                                else if(page.localeCompare("__USERS__")==0) users();
                                else if(page.localeCompare("__PAGES__")==0) gestion_pages();
                                else if(page.localeCompare("__NAVBAR__")==0) gestion_navbar();
                                else if(page.localeCompare("__CAROUSELS__")==0) gestion_carousels();
                                else if(page.localeCompare("__IMAGES__")==0) gestion_images();
                                else loadPageWebsite(page);
                            }
                            else {
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "getPages", 
                                             data : { name : pseudo, pwd : mdp } },
                                    success: function(res){
                                        loadNavbar(Array.from(res), data, false);
                                        //Chargement de la page
                                        if(page.localeCompare("__ACCUEIL__")==0) accueil();
                                        else if(page.localeCompare("__CNFDNCLT__")==0) cnfdnclt();
                                        else loadPageWebsite(page);
                                    }
                                });
                            }
                        }
                    });
                    //Chargement du footer
                    $("div.footer").empty().append(`<p>${data.footer}</p>`);

                    function accueil() {
                        $.ajax({
                            type : "POST",
                            url  : "../data/analytics.php",
                            data : { function : "getVues", admin : true },
                            success : function(analytics) {
                                $("div.contenu").empty();
                                $("div.contenu").append(`<div class="analytics">
                                                          <canvas id="myChart"></canvas>
                                                        </div>`);
                                const labels = analytics.jours;
                                const data = {
                                    labels: labels,
                                    datasets: [{
                                      label: 'Vues',
                                      backgroundColor: 'rgb(255, 99, 132)',
                                      borderColor: 'rgb(255, 99, 132)',
                                      data: analytics.vues,
                                    },{
                                      label: 'Vues (Administration)',
                                      backgroundColor: 'rgb(0, 0, 139)',
                                      borderColor: 'rgb(0, 0, 139)',
                                      data: analytics.vuesAdmin,
                                    }]
                                };

                                const config = {
                                    type: 'line',
                                    data: data,
                                    options: {
                                    responsive: true,
                                    plugins: {
                                      title: {
                                        display: true,
                                        text: (ctx) => 'Vues du site (7 derniers jours)',
                                      }
                                    }
                                    }
                                };

                                const myChart = new Chart(
                                    document.getElementById('myChart'),
                                    config
                                );
                            }
                        });
                    }

                    function settings() {
                        $("div.contenu").empty();
                        $("div.contenu").append(
                        $(`<div>
                               <div class="settings row"><label class="col-3" for="nomsite">Nom du site</label>
                               <input class="col-6" type="text" id="nomsite" name="nomsite" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="desc">Description</label>
                               <input class="col-6" type="text" id="desc" name="desc" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="keywords">Mots clés (séparés par une virgule)</label>
                               <input class="col-6" type="text" id="keywords" name="keywords" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="logo">URL Logo</label>
                               <input class="col-6" type="text" id="logo" name="logo" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="player">URL Player</label>
                               <input class="col-6" type="text" id="player" name="player" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="copyright">Copyright de bas de page</label>
                               <input class="col-6" type="text" id="copyright" name="copyright" required minlength="4" size="50"></input></div>
                               <div class="settings row"><div class="col-2"></div><input class="col-2" type="submit" id="submit" value="Mettre à jour" style="width: auto;"><div class="col-8"></div></div>
                               <p id="result"></p>
                           </div>`));
                        $("input#nomsite").val(data.nom);
                        $("input#desc").val(data.description);
                        $("input#keywords").val(data.keywords);
                        $("input#player").val(data.urlPlayer);
                        $("input#logo").val(data.logo);
                        $("input#copyright").val(data.footer);
                        $("input#submit").click(function(e) {
                            e.preventDefault();
                            data.nom = $("input#nomsite").val();
                            data.description = $("input#desc").val();
                            data.keywords = $("input#keywords").val();
                            data.urlPlayer = $("input#player").val();
                            data.logo = $("input#logo").val();
                            data.footer = $("input#copyright").val();
                            $.ajax({
                                type : "POST",
                                url  : "../data/data.php",
                                data : { function : "updateSettings", 
                                         data : { name : pseudo, pwd : mdp,
                                                  nom : $("input#nomsite").val(), description : $("input#desc").val(),
                                                  keywords : $("input#keywords").val(), player : $("input#player").val(),
                                                  logo : $("input#logo").val(), copyright : $("input#copyright").val() } },
                                success: function(res){
                                    $("div.footer").empty().append(`<p>${data.footer}</p>`);
                                    if(res == 0)
                                        $("p#result").empty().show().html(`<p style="color: green;">Données mises à jour.</p>`).delay(3000).fadeOut(300);
                                    else
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour des données.</p>`).delay(3000).fadeOut(300);
                                }
                            });
                        });
                    }

                    function users(reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;
                        $.ajax({
                            type : "POST",
                            url  : "../data/data.php",
                            data : { function : "getUsers", 
                                     data : { name : pseudo, pwd : mdp } },
                            success: function(res){
                                console.log(res);
                                $("div.contenu").empty();
                                var d = $(`<div class="table100 ver1">`);
                                d.append(`<table>
                                                <thead class="table100-head">
                                                    <tr class="row100 head">
                                                        <th class="cell100 column1"><p>Utilisateur</p></th>
                                                        <th class="cell100 column2"><p>Mot de passe (SHA-256)</p></th>
                                                        <th class="cell100 column3"><p>Admin</p></th>
                                                        <th class="cell100 column4"><p>Pages</p></th>
                                                        <th class="cell100 column5"></th>
                                                        <th class="cell100 column5"></th>
                                                    </tr>
                                                </thead>
                                            </table>`);
                                var divScroll = $(`<div class="table100-body js-pscroll">`);
                                var t = $(`<table></table>`);
                                var r = $(`<tbody class="settings"></tbody>`);
                                var pages = Object.keys(data.pages);
                                //Utlisateurs inscrits
                                for (let key of Object.keys(res)) {
                                    var l = $(`<tr class="row100 body"></tr>`);
                                    l.append(`<td id=`+key+` class="cell100 column1"><p type="text" id="user">`+key+`</p></td>`);
                                    l.append(`<td id=`+key+` class="cell100 column2"><input type="text" id="pwd" required minlength="4" style="width: 100%;" value="`+res[key].pwd+`"></input></td>`);
                                    var td = $(`<td id=`+key+` class="cell100 column3"></td>`);
                                    var checkbox = $(`<input type="checkbox" id="admin"></input>`);
                                    checkbox.prop('checked', res[key].admin);
                                    td.append(checkbox);
                                    l.append(td);
                                    var tdPages = $(`<td id=`+key+` class="cell100 column4 checkboxes"></td>`);
                                    for (let page of pages) {
                                        var divPages = $(`<div style="display: inline-flex; margin: auto;"></div>`);
                                        var cPage = $(`<input style="margin-right: 10px;" type="checkbox" id="pages`+key+page+`"></input>`);
                                        if(res[key].pages != null) cPage.prop('checked', res[key].pages.includes(page));
                                        var p = $(`<p page="`+page+`"></p>`);
                                        p.append(cPage);
                                        if(page == "index") {
                                            p.append(`<label for="pages`+key+page+`">Page d'accueil</label>`);
                                        }
                                        else
                                            p.append(`<label for="pages`+key+page+`">`+data.pages[page].nom+`</label>`);
                                        divPages.append(p);
                                        tdPages.append(divPages);
                                    }
                                    l.append(tdPages);
                                    var suppr = $(`<input type="button" value="Supprimer ×"></input>`);
                                    var tdSuppr = $(`<td class="cell100 column5"></td>`);
                                    tdSuppr.append(suppr);
                                    tdSuppr.click(function(e) {
                                        e.preventDefault();
                                        if(confirm("Voulez-vous vraiment supprimer cet utilisateur?\n(" + key + ")")) {
                                            $.ajax({
                                                type : "POST",
                                                url  : "../data/data.php",
                                                data : { function : "removeUser", 
                                                         data : { name : pseudo, pwd : mdp,
                                                                  nameToRemove : key} },
                                                success: function(res){
                                                    users(res);
                                                }
                                            });
                                        }
                                    });
                                    l.append(tdSuppr);
                                    var maj = $(`<input type="button" value="Mettre à jour"></input>`);
                                    var tdMaj = $(`<td class="cell100 column5"></td>`);
                                    maj.click(function(e) {
                                        e.preventDefault();
                                        res[key].pwd = $("td#"+key+".column2").find("input[type=text]").val();
                                        res[key].admin = $("td#"+key+".column3").find("input[type=checkbox]").prop('checked');
                                        var new_pwd = res[key].pwd;
                                        var p = $("td#"+key+".column4").find("p");
                                        if(res[key].pages == null) res[key].pages = [];
                                        p.each(function( i ) {
                                            if(res[key].pages.includes($( this ).attr("page"))) {
                                                if($( this ).find("input[type=checkbox]").prop('checked') != true) {
                                                    const index = res[key].pages.indexOf($( this ).attr("page"));
                                                    if(index > -1) {
                                                        res[key].pages.splice(index, 1);
                                                    }
                                                }
                                            }
                                            else if($( this ).find("input[type=checkbox]").prop('checked')) {
                                                res[key].pages.push($( this ).attr("page"));
                                            }
                                        });
                                        $.ajax({
                                            type : "POST",
                                            url  : "../data/data.php",
                                            data : { function : "addUser", 
                                                     data : { name : pseudo, pwd : mdp,
                                                              nameToAdd : key, pwdToAdd : res[key].pwd,
                                                              adminToAdd : res[key].admin, pagesToAdd : res[key].pages} },
                                            success: function(res){
                                                //Mise à jour du localStorage si c'est l'utilisateur lui-même:
                                                if(pseudo == key) {
                                                    localStorage.setItem("mdp", new_pwd);
                                                    mdp = new_pwd;
                                                }
                                                users(res);
                                            }
                                        });
                                    });
                                    tdMaj.append(maj);
                                    l.append(tdMaj);
                                    r.append(l);
                                }
                                //On ajoute tout le tableau des utilisateurs:
                                t.append(r);
                                divScroll.append(t);
                                d.append(divScroll);
                                //Ligne d'ajout d'un utilisateur
                                var divScrollAdd = $(`<div class="table100-body js-pscroll">`);
                                var tAdd = $(`<table></table>`);
                                var rAdd = $(`<tbody class="settings"></tbody>`);
                                var lAdd = $(`<tr class="row100 body"></tr>`);
                                lAdd.append(`<td id="__ADDUSER__" class="cell100 column1"><input type="text" id="user"></input></td>`);
                                lAdd.append(`<td id="__ADDUSER__" class="cell100 column2"><input type="text" id="pwd" required minlength="4" style="width: 100%;"></input></td>`);
                                lAdd.append(`<td id="__ADDUSER__" class="cell100 column3"><input type="checkbox" id="admin"></input></td>`);
                                var tdPages = $(`<td id="__ADDUSER__" class="cell100 column4 checkboxes"></td>`);
                                for (let page of pages) {
                                    var divPages = $(`<div style="display: inline-flex; margin: auto;"></div>`);
                                    var cPage = $(`<input style="margin-right: 10px;" type="checkbox" id="pages__ADDUSER__`+page+`"></input>`);
                                    var p = $(`<p page="`+page+`"></p>`);
                                    p.append(cPage);
                                    if(page == "index") {
                                        p.append(`<label for="pages__ADDUSER__`+page+`">Page d'accueil</label>`);
                                    }
                                    else
                                        p.append(`<label for="pages__ADDUSER__`+page+`">`+data.pages[page].nom+`</label>`);
                                    divPages.append(p);
                                    tdPages.append(divPages);
                                }
                                lAdd.append(tdPages);
                                var ajout = $(`<input type="button" value="Ajouter l'utilisateur"></input>`);
                                ajout.click(function(e) {
                                    e.preventDefault();
                                    var user = $("td#__ADDUSER__.column1").find("input[type=text]").val();
                                    //Check utilisateur déjà existant à faire ICI
                                    if(user in res) {
                                        users(2);
                                        return;
                                    }
                                    res[user] = {"pwd": $("td#__ADDUSER__.column2").find("input[type=text]").val(),
                                                 "admin": $("td#__ADDUSER__.column3").find("input[type=checkbox]").prop('checked'),
                                                 "pages": []};
                                    var p = $("td#__ADDUSER__.column4").find("p");
                                    p.each(function( i ) {
                                        if($( this ).find("input[type=checkbox]").prop('checked')) {
                                            res[user].pages.push($( this ).attr("page"));
                                        }
                                    });
                                    $.ajax({
                                        type : "POST",
                                        url  : "../data/data.php",
                                        data : { function : "addUser", 
                                                 data : { name : pseudo, pwd : mdp,
                                                          nameToAdd : user, pwdToAdd : sha256(res[user].pwd),
                                                          adminToAdd : res[user].admin, pagesToAdd : res[user].pages} },
                                        success: function(res){
                                            users(res);
                                        }
                                    });
                                });
                                var tdAjout = $(`<td class="cell100 column5"></td>`);
                                tdAjout.append(ajout);
                                lAdd.append(tdAjout);
                                lAdd.append(`<td class="cell100 column5"></td>`);
                                rAdd.append(lAdd);
                                tAdd.append(rAdd);
                                divScrollAdd.append(tAdd);
                                d.append(divScrollAdd);
                                $("div.contenu").append(d);
                                $("div.contenu").append(`<label name="encoder">Encoder SHA-256: </label>`);
                                var encoder = $('<input name="encoder" type="text" class="encodesha256">');
                                encoder.keyup(function(e) {
                                    if(e.target.value.empty)
                                        $("p#result").html("").show();
                                    else
                                        $("p#result").html(sha256(e.target.value)).show();
                                });
                                $("div.contenu").append(encoder);
                                $("div.contenu").append(`<p id="result"></p>`);
                                if(reponse != 1) {
                                    if(reponse == 0)
                                        $("p#result").empty().show().html(`<p style="color: green;">Données mises à jour.</p>`).delay(3000).fadeOut(300);
                                    else if(reponse == 2)
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur, l'utilisateur existe déjà.</p>`).delay(3000).fadeOut(300);
                                    else
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour des données.</p>`).delay(3000).fadeOut(300);
                                }
                            }
                        });
                        
                    }

                    function gestion_pages(reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;
                        $("div.contenu").empty();
                        var d = $(`<div class="table100 ver1">`);
                        d.append(`<table>
                                        <thead class="table100-head">
                                            <tr class="row100 head">
                                                <th class="cell100 column1"><p>ID</p></th>
                                                <th class="cell100 column2"><p>Nom de la page</p></th>
                                                <th class="cell100 column5"></th>
                                                <th class="cell100 column5"></th>
                                            </tr>
                                        </thead>
                                    </table>`);
                        var divScroll = $(`<div class="table100-body js-pscroll">`);
                        var t = $(`<table></table>`);
                        var r = $(`<tbody class="settings"></tbody>`);
                        var pages = Object.keys(data.pages);
                        for (let p of pages) {
                            var l = $(`<tr class="row100 body"></tr>`);
                            if(p == "index")
                                l.append(`<td class="cell100 column1"><input type="text" id="id${p}" value="${p}" readonly></input></td>`);
                            else
                                l.append(`<td class="cell100 column1"><input type="text" id="id${p}" value="${p}"></input></td>`);
                            l.append(`<td class="cell100 column2"><input type="text" id="nom${p}" value="${data.pages[p].nom}"></input></td>`);
                            var maj = $(`<input idpage="${p}" type="button" value="Mettre à jour"></input>`);
                            var tdMaj = $(`<td class="cell100 column5"></td>`);
                            maj.click(function(e) {
                                e.preventDefault();
                                var idpage = $( this ).attr("idpage");
                                const contenu = data.pages[idpage].contenu;
                                delete data.pages[idpage];
                                data.pages[$("input[type=text]#id"+idpage).val()] = {nom: $("input[type=text]#nom"+idpage).val(),
                                                      contenu: contenu};
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "updatePages", 
                                             data : { name : pseudo, pwd : mdp,
                                                      pages : data.pages} },
                                    success: function(res){
                                        var pages = Object.keys(data.pages);
                                        loadNavbar(pages, data);
                                        gestion_pages(res);
                                    }
                                });
                            });
                            tdMaj.append(maj);
                            l.append(tdMaj);
                            if(p != "index") {
                                var suppr = $(`<input idpage="${p}" type="button" value="Supprimer ×"></input>`);
                                var tdSuppr = $(`<td class="cell100 column5"></td>`);
                                tdSuppr.append(suppr);
                                suppr.click(function(e) {
                                    e.preventDefault();
                                    if(confirm("Voulez-vous vraiment supprimer cette page?\n(" + p + ")")) {
                                        delete data.pages[p];
                                        $.ajax({
                                            type : "POST",
                                            url  : "../data/data.php",
                                            data : { function : "updatePages", 
                                                     data : { name : pseudo, pwd : mdp,
                                                              pages : data.pages} },
                                            success: function(res){
                                                var pages = Object.keys(data.pages);
                                                loadNavbar(pages, data);
                                                gestion_pages(res);
                                            }
                                        });
                                    }
                                });
                                l.append(tdSuppr);
                            }
                            r.append(l);
                        }
                        r.append(l);
                        t.append(r);
                        divScroll.append(t);
                        d.append(divScroll);
                        //Ligne d'ajout d'une page
                        var divScrollAdd = $(`<div class="table100-body js-pscroll">`);
                        var tAdd = $(`<table></table>`);
                        var rAdd = $(`<tbody class="settings"></tbody>`);
                        var lAdd = $(`<tr class="row100 body"></tr>`);
                        lAdd.append(`<td class="cell100 column1"><input type="text" id="id__ADDPAGE__"></input></td>`);
                        lAdd.append(`<td class="cell100 column2"><input type="text" id="nom__ADDPAGE__"></input></td>`);
                        var tdAjout = $(`<td class="cell100 column5"></td>`);
                        var ajout = $(`<input type="button" value="Ajouter la page"></input>`);
                        ajout.click(function(e) {
                            e.preventDefault();
                            var page = $("input[type=text]#id__ADDPAGE__").val();
                            if(page in data.pages) {
                                gestion_pages(2);
                                return;
                            }
                            var idpage = $( this ).attr("idpage");
                            data.pages[page] = {nom: $("input[type=text]#nom__ADDPAGE__").val(),
                                                  contenu: ""};
                            $.ajax({
                                type : "POST",
                                url  : "../data/data.php",
                                data : { function : "updatePages", 
                                         data : { name : pseudo, pwd : mdp,
                                                  pages : data.pages} },
                                success: function(res){
                                    var pages = Object.keys(data.pages);
                                    loadNavbar(pages, data);
                                    gestion_pages(res);
                                }
                            });
                        });
                        tdAjout.append(ajout);
                        lAdd.append(tdAjout);
                        lAdd.append(`<td class="cell100 column5"></td>`);
                        rAdd.append(lAdd);
                        tAdd.append(rAdd);
                        divScrollAdd.append(tAdd);
                        d.append(divScrollAdd);
                        $("div.contenu").append(d);
                        $("div.contenu").append(`<p id="result"></p>`);
                        if(reponse != 1) {
                            if(reponse == 0)
                                $("p#result").empty().show().html(`<p style="color: green;">Données mises à jour.</p>`).delay(3000).fadeOut(300);
                            else if(reponse == 2)
                                $("p#result").empty().show().html(`<p style="color: red;">Erreur, La page existe déjà.</p>`).delay(3000).fadeOut(300);
                            else
                                $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour des données.</p>`).delay(3000).fadeOut(300);
                        }
                        //loadData("__PAGES__");
                    }

                    function gestion_navbar(reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;
                        $("div.contenu").empty();
                        //HEADER
                        $("div.contenu").append(`<h1>Liens du header</h1>`);
                        var d = $(`<div class="table100 ver1">`);
                        d.append(`<table>
                                        <thead class="table100-head">
                                            <tr class="row100 head">
                                                <th class="cell100 column1"><p>Nom de la page</p></th>
                                                <th class="cell100 column2"><p>Position</p></th>
                                                <th class="cell100 column3"><p>Lien de la page</p></th>
                                                <th class="cell100 column4"><p>Sous Menu</p></th>
                                                <th class="cell100 column5"></th>
                                                <th class="cell100 column5"></th>
                                            </tr>
                                        </thead>
                                    </table>`);
                        var divScroll = $(`<div class="table100-body js-pscroll">`);
                        var t = $(`<table></table>`);
                        var r = $(`<tbody class="settings"></tbody>`);
                        var liensHeader = data.liensHeader;
                        liensHeader.sort(function (x, y) {
                            return x.pos - y.pos;
                        });
                        for (var i = 0; i < liensHeader.length; i++) {
                            var l = $(`<tr class="row100 body"></tr>`);
                            l.append(`<td class="cell100 column1"><input type="text" id="header_nom${String(liensHeader[i].nom).hashCode()}" value="${liensHeader[i].nom}"></input></td>`);
                            l.append(`<td class="cell100 column2"><input type="text" id="header_pos${String(liensHeader[i].nom).hashCode()}" value="${liensHeader[i].pos}"></input></td>`);
                            l.append(`<td class="cell100 column3"><input type="text" id="header_lien${String(liensHeader[i].nom).hashCode()}" value="${liensHeader[i].lien}"></input></td>`);
                            var dsm = $(`<div class="table100 ver1 sm cell100">`);
                            dsm.append(`<table>
                                            <thead class="table100-head">
                                                <tr class="row100 head">
                                                    <th class="cell100 column1"><p>Nom de la page</p></th>
                                                    <th class="cell100 column2"><p>Position</p></th>
                                                    <th class="cell100 column3"><p>Lien de la page</p></th>
                                                    <th class="cell100 column5"></th>
                                                    <th class="cell100 column5"></th>
                                                </tr>
                                            </thead>
                                        </table>`);
                            var divScrollSM = $(`<div class="table100-body js-pscroll">`);
                            var tsm = $(`<table></table>`);
                            var rsm = $(`<tbody class="settings" id="header_sm${String(liensHeader[i].nom).hashCode()}"></tbody>`);
                            if(!liensHeader[i].hasOwnProperty("sousMenu")) liensHeader[i]["sousMenu"] = Array();
                            var liensHeaderSM = data.liensHeader[i].sousMenu;
                            liensHeaderSM.sort(function (x, y) {
                                return x.pos - y.pos;
                            });
                            for (var j = 0; j < liensHeaderSM.length; j++) {
                                var lsm = $(`<tr class="row100 body"></tr>`);
                                lsm.append(`<td class="cell100 column1"><input type="text" id="header_sm_nom" value="${liensHeaderSM[j].nom}"></input></td>`);
                                lsm.append(`<td class="cell100 column2"><input type="text" id="header_sm_pos" value="${liensHeaderSM[j].pos}"></input></td>`);
                                lsm.append(`<td class="cell100 column3"><input type="text" id="header_sm_lien" value="${liensHeaderSM[j].lien}"></input></td>`);
                                var maj = $(`<input idheader="${String(liensHeader[i].nom).hashCode()}" id="${String(i)}" idsm="${String(j)}" type="button" value="Mettre à jour"></input>`);
                                var tdMaj = $(`<td class="cell100 column5"></td>`);
                                maj.click(function(e) {
                                    e.preventDefault();
                                    var idheader = $( this ).attr("idheader");
                                    var id = parseInt($( this ).attr("id"), 10);
                                    var idsm = parseInt($( this ).attr("idsm"), 10);
                                    data.liensHeader[id].sousMenu[idsm].nom = $("tbody#header_sm"+idheader).find("input#header_sm_nom")[idsm].value;
                                    data.liensHeader[id].sousMenu[idsm].pos = $("tbody#header_sm"+idheader).find("input#header_sm_pos")[idsm].value;
                                    data.liensHeader[id].sousMenu[idsm].lien = $("tbody#header_sm"+idheader).find("input#header_sm_lien")[idsm].value;
                                    $.ajax({
                                        type : "POST",
                                        url  : "../data/data.php",
                                        data : { function : "updateHeader", 
                                                 data : { name : pseudo, pwd : mdp,
                                                          header : data.liensHeader} },
                                        success: function(res){
                                            gestion_navbar(res);
                                        }
                                    });
                                });
                                tdMaj.append(maj);
                                lsm.append(tdMaj);
                                var suppr = $(`<input id="${String(i)}" idsm="${String(j)}" type="button" value="Supprimer ×"></input>`);
                                var tdSuppr = $(`<td class="cell100 column5"></td>`);
                                tdSuppr.append(suppr);
                                suppr.click(function(e) {
                                    e.preventDefault();
                                    var id = parseInt($( this ).attr("id"), 10);
                                    var idsm = parseInt($( this ).attr("idsm"), 10);
                                    if(confirm("Voulez-vous vraiment supprimer ce lien?\n(" + data.liensHeader[id].sousMenu[idsm].nom + ")")) {
                                        data.liensHeader[id].sousMenu.splice(idsm, 1);
                                        $.ajax({
                                            type : "POST",
                                            url  : "../data/data.php",
                                            data : { function : "updateHeader", 
                                                     data : { name : pseudo, pwd : mdp,
                                                              header : data.liensHeader} },
                                            success: function(res){
                                                gestion_navbar(res);
                                            }
                                        });
                                    }
                                });
                                lsm.append(tdSuppr);
                                rsm.append(lsm);
                            }
                            tsm.append(rsm);
                            divScrollSM.append(tsm);
                            dsm.append(divScrollSM);
                            var divScrollAddSM = $(`<div class="table100-body js-pscroll">`);
                            var tAddSM = $(`<table></table>`);
                            var rAddSM = $(`<tbody class="settings"></tbody>`);
                            var lAddSM = $(`<tr class="row100 body"></tr>`);
                            lAddSM.append(`<td class="cell100 column1"><input type="text" id="header_nom__ADDLINK__${String(liensHeader[i].nom).hashCode()}"></input></td>`);
                            lAddSM.append(`<td class="cell100 column2"><input type="text" id="header_pos__ADDLINK__${String(liensHeader[i].nom).hashCode()}"></input></td>`);
                            lAddSM.append(`<td class="cell100 column3"><input type="text" id="header_lien__ADDLINK__${String(liensHeader[i].nom).hashCode()}"></input></td>`);
                            var addSM = $(`<input type="button" idheader="${String(liensHeader[i].nom).hashCode()}" id="${String(i)}" value="Ajouter le lien"></input>`);
                            var tdAddSM = $(`<td class="cell100 column4"></td>`);
                            addSM.click(function(e) {
                                e.preventDefault();
                                var idheader = $( this ).attr("idheader");
                                var id = parseInt($( this ).attr("id"), 10);
                                data.liensHeader[id].sousMenu.push({nom: $("input[type=text]#header_nom__ADDLINK__"+idheader).val(),
                                                                    pos: parseInt($("input[type=text]#header_pos__ADDLINK__"+idheader).val(), 10),
                                                                    lien: $("input[type=text]#header_lien__ADDLINK__"+idheader).val()});
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "updateHeader", 
                                             data : { name : pseudo, pwd : mdp,
                                                      header : data.liensHeader} },
                                    success: function(res){
                                        gestion_navbar(res);
                                    }
                                });
                            });
                            tdAddSM.append(addSM);
                            lAddSM.append(tdAddSM);
                            lAddSM.append(`<td class="cell100 column5"></td>`);
                            lAddSM.append(`<td class="cell100 column5"></td>`);
                            rAddSM.append(lAddSM);
                            tAddSM.append(rAddSM);
                            divScrollAddSM.append(tAddSM);
                            dsm.append(divScrollAddSM);
                            l.append(dsm);
                            var maj = $(`<input idheader="${String(liensHeader[i].nom).hashCode()}" id="${String(i)}" type="button" value="Mettre à jour"></input>`);
                            var tdMaj = $(`<td class="cell100 column5"></td>`);
                            maj.click(function(e) {
                                e.preventDefault();
                                var idheader = $( this ).attr("idheader");
                                var id = parseInt($( this ).attr("id"), 10);
                                data.liensHeader[id].nom = $("input[type=text]#header_nom"+idheader).val();
                                data.liensHeader[id].pos = parseInt($("input[type=text]#header_pos"+idheader).val(), 10);
                                data.liensHeader[id].lien = $("input[type=text]#header_lien"+idheader).val();
                                var sm = Array();
                                var sm_nom = $("tbody#header_sm"+idheader).find("input#header_sm_nom");
                                var sm_pos = $("tbody#header_sm"+idheader).find("input#header_sm_pos");
                                var sm_lien = $("tbody#header_sm"+idheader).find("input#header_sm_lien");
                                for(let j = 0; j<sm_nom.length; j++) {
                                    sm[j] = {nom: sm_nom[j].value,
                                             pos: parseInt(sm_pos[j].value, 10),
                                             lien: sm_lien[j].value};
                                }
                                data.liensHeader[id].sousMenu = sm;
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "updateHeader", 
                                             data : { name : pseudo, pwd : mdp,
                                                      header : data.liensHeader} },
                                    success: function(res){
                                        gestion_navbar(res);
                                    }
                                });
                            });
                            tdMaj.append(maj);
                            l.append(tdMaj);
                            var suppr = $(`<input id="${String(i)}" type="button" value="Supprimer ×"></input>`);
                            var tdSuppr = $(`<td class="cell100 column5"></td>`);
                            tdSuppr.append(suppr);
                            suppr.click(function(e) {
                                e.preventDefault();
                                var id = parseInt($( this ).attr("id"), 10);
                                if(confirm("Voulez-vous vraiment supprimer ce lien?\n(" + data.liensHeader[id].nom + ")")) {
                                    data.liensHeader.splice(id, 1);
                                    $.ajax({
                                        type : "POST",
                                        url  : "../data/data.php",
                                        data : { function : "updateHeader", 
                                                 data : { name : pseudo, pwd : mdp,
                                                          header : data.liensHeader} },
                                        success: function(res){
                                            gestion_navbar(res);
                                        }
                                    });
                                }
                            });
                            l.append(tdSuppr);
                            r.append(l);
                        }
                        t.append(r);
                        divScroll.append(t);
                        d.append(divScroll);
                        var divScrollAdd = $(`<div class="table100-body js-pscroll">`);
                        var tAdd = $(`<table></table>`);
                        var rAdd = $(`<tbody class="settings"></tbody>`);
                        var lAdd = $(`<tr class="row100 body"></tr>`);
                        lAdd.append(`<td class="cell100 column1"><input type="text" id="header_nom__ADDLINK__"></input></td>`);
                        lAdd.append(`<td class="cell100 column2"><input type="text" id="header_pos__ADDLINK__"></input></td>`);
                        lAdd.append(`<td class="cell100 column3"><input type="text" id="header_lien__ADDLINK__"></input></td>`);
                        var add = $(`<input type="button" value="Ajouter le lien"></input>`);
                        var tdAdd = $(`<td class="cell100 column4"></td>`);
                        add.click(function(e) {
                            e.preventDefault();
                            data.liensHeader.push({nom: $("input[type=text]#header_nom__ADDLINK__").val(),
                                                   pos: parseInt($("input[type=text]#header_pos__ADDLINK__").val(), 10),
                                                   lien: $("input[type=text]#header_lien__ADDLINK__").val(),
                                                   sousMenu: Array()});
                            $.ajax({
                                type : "POST",
                                url  : "../data/data.php",
                                data : { function : "updateHeader", 
                                         data : { name : pseudo, pwd : mdp,
                                                  header : data.liensHeader} },
                                success: function(res){
                                    gestion_navbar(res);
                                }
                            });
                        });
                        tdAdd.append(add);
                        lAdd.append(tdAdd);
                        lAdd.append(`<td class="cell100 column5"></td>`);
                        lAdd.append(`<td class="cell100 column5"></td>`);
                        rAdd.append(lAdd);
                        tAdd.append(rAdd);
                        divScrollAdd.append(tAdd);
                        d.append(divScrollAdd);
                        $("div.contenu").append(d);
                        //FOOTER
                        $("div.contenu").append(`<h1>Liens du footer</h1>`);
                        var d = $(`<div class="table100 ver1">`);
                        d.append(`<table>
                                        <thead class="table100-head">
                                            <tr class="row100 head">
                                                <th class="cell100 column1"><p>Nom de la page</p></th>
                                                <th class="cell100 column2"><p>Position</p></th>
                                                <th class="cell100 column3"><p>Lien de la page</p></th>
                                                <th class="cell100 column5"></th>
                                                <th class="cell100 column5"></th>
                                            </tr>
                                        </thead>
                                    </table>`);
                        var divScroll = $(`<div class="table100-body js-pscroll">`);
                        var t = $(`<table></table>`);
                        var r = $(`<tbody class="settings"></tbody>`);
                        var liensFooter = data.liensFooter;
                        liensFooter.sort(function (x, y) {
                            return x.pos - y.pos;
                        });
                        for (var i = 0; i < liensFooter.length; i++) {
                            var l = $(`<tr class="row100 body"></tr>`);
                            l.append(`<td class="cell100 column1"><input type="text" id="footer_nom${String(liensFooter[i].nom).hashCode()}" value="${liensFooter[i].nom}"></input></td>`);
                            l.append(`<td class="cell100 column2"><input type="text" id="footer_pos${String(liensFooter[i].nom).hashCode()}" value="${liensFooter[i].pos}"></input></td>`);
                            l.append(`<td class="cell100 column3"><input type="text" id="footer_lien${String(liensFooter[i].nom).hashCode()}" value="${liensFooter[i].lien}"></input></td>`);
                            var maj = $(`<input idfooter="${String(liensFooter[i].nom).hashCode()}" id="${String(i)}" type="button" value="Mettre à jour"></input>`);
                            var tdMaj = $(`<td class="cell100 column5"></td>`);
                            maj.click(function(e) {
                                e.preventDefault();
                                var idfooter = $( this ).attr("idfooter");
                                var id = parseInt($( this ).attr("id"), 10);
                                data.liensFooter[id].nom = $("input[type=text]#footer_nom"+idfooter).val();
                                data.liensFooter[id].pos = parseInt($("input[type=text]#footer_pos"+idfooter).val(), 10);
                                data.liensFooter[id].lien = $("input[type=text]#footer_lien"+idfooter).val();
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "updateFooter", 
                                             data : { name : pseudo, pwd : mdp,
                                                      footer : data.liensFooter} },
                                    success: function(res){
                                        gestion_navbar(res);
                                    }
                                });
                            });
                            tdMaj.append(maj);
                            l.append(tdMaj);
                            var suppr = $(`<input id="${String(i)}" type="button" value="Supprimer ×"></input>`);
                            var tdSuppr = $(`<td class="cell100 column5"></td>`);
                            tdSuppr.append(suppr);
                            suppr.click(function(e) {
                                e.preventDefault();
                                var id = parseInt($( this ).attr("id"), 10);
                                if(confirm("Voulez-vous vraiment supprimer ce lien?\n(" + data.liensFooter[id].nom + ")")) {
                                    data.liensFooter.splice(id, 1);
                                    $.ajax({
                                        type : "POST",
                                        url  : "../data/data.php",
                                        data : { function : "updateFooter", 
                                                 data : { name : pseudo, pwd : mdp,
                                                          footer : data.liensFooter} },
                                        success: function(res){
                                            gestion_navbar(res);
                                        }
                                    });
                                }
                            });
                            l.append(tdSuppr);
                            r.append(l);
                        }
                        t.append(r);
                        divScroll.append(t);
                        d.append(divScroll);
                        var divScrollAdd = $(`<div class="table100-body js-pscroll">`);
                        var tAdd = $(`<table></table>`);
                        var rAdd = $(`<tbody class="settings"></tbody>`);
                        var lAdd = $(`<tr class="row100 body"></tr>`);
                        lAdd.append(`<td class="cell100 column1"><input type="text" id="footer_nom__ADDLINK__"></input></td>`);
                        lAdd.append(`<td class="cell100 column2"><input type="text" id="footer_pos__ADDLINK__"></input></td>`);
                        lAdd.append(`<td class="cell100 column3"><input type="text" id="footer_lien__ADDLINK__"></input></td>`);
                        var add = $(`<input type="button" value="Ajouter le lien"></input>`);
                        var tdAdd = $(`<td class="cell100 column5"></td>`);
                        add.click(function(e) {
                            e.preventDefault();
                            data.liensFooter.push({nom: $("input[type=text]#footer_nom__ADDLINK__").val(),
                                                   pos: parseInt($("input[type=text]#footer_pos__ADDLINK__").val(), 10),
                                                   lien: $("input[type=text]#footer_lien__ADDLINK__").val()});
                            $.ajax({
                                type : "POST",
                                url  : "../data/data.php",
                                data : { function : "updateHeader", 
                                         data : { name : pseudo, pwd : mdp,
                                                  footer : data.liensFooter} },
                                success: function(res){
                                    gestion_navbar(res);
                                }
                            });
                        });
                        tdAdd.append(add);
                        lAdd.append(tdAdd);
                        lAdd.append(`<td class="cell100 column5"></td>`);
                        rAdd.append(lAdd);
                        tAdd.append(rAdd);
                        divScrollAdd.append(tAdd);
                        d.append(divScrollAdd);
                        $("div.contenu").append(d);
                        $("div.contenu").append(`<p id="result"></p>`);
                        if(reponse != 1) {
                            if(reponse == 0)
                                $("p#result").empty().show().html(`<p style="color: green;">Données mises à jour.</p>`).delay(3000).fadeOut(300);
                            else if(reponse == 2)
                                $("p#result").empty().show().html(`<p style="color: red;">Erreur, Le lien existe déjà.</p>`).delay(3000).fadeOut(300);
                            else
                                $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour des données.</p>`).delay(3000).fadeOut(300);
                        }
                    }

                    function gestion_carousels(reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;

                        $.ajax({
                            type : "POST",
                            url  : "../data/data.php",
                            data : { function : "getImages", 
                                     data : { name : pseudo, pwd : mdp }},
                            success: function(res){
                                $("div.contenu").empty();
                                var dataImages = Array();
                                for(let i=0; i<res.length; i++) {
                                    dataImages.push({
                                        ID: i,
                                        Image: res[i],
                                        Nom: res[i].replace("../images/upload/", ""),
                                    });
                                }

                                $("div.contenu").append(`<h1>Carousels</h1>`);
                                var d = $(`<div class="table100 ver1">`);
                                d.append(`<table>
                                                <thead class="table100-head">
                                                    <tr class="row100 head">
                                                        <th class="cell100 column5"><p>ID</p></th>
                                                        <th class="cell100 column4"><p>Contenu</p></th>
                                                        <th class="cell100 column5"></th>
                                                    </tr>
                                                </thead>
                                            </table>`);
                                var divScroll = $(`<div class="table100-body js-pscroll">`);
                                var t = $(`<table></table>`);
                                var r = $(`<tbody class="settings"></tbody>`);
                                var carousels = data.carousels;
                                var kCarousels = Object.keys(data.carousels);
                                for (let k of kCarousels) {
                                    var l = $(`<tr class="row100 body"></tr>`);
                                    l.append(`<td class="cell100 column1"><p class="clipboard" id="carousels_id${String(k).hashCode()}">${k}</p></td>`);
                                    var dsm = $(`<div class="table100 ver1 sm cell100">`);
                                    dsm.append(`<table>
                                                    <thead class="table100-head">
                                                        <tr class="row100 head">
                                                            <th class="cell100 column4"><p>Image</p></th>
                                                            <th class="cell100 column2"><p>Titre</p></th>
                                                            <th class="cell100 column2"><p>Description</p></th>
                                                            <th class="cell100 column3"><p>Lien</p></th>
                                                            <th class="cell100 column5"></th>
                                                            <th class="cell100 column5"></th>
                                                        </tr>
                                                    </thead>
                                                </table>`);
                                    var divScrollSM = $(`<div class="table100-body js-pscroll">`);
                                    var tsm = $(`<table></table>`);
                                    var rsm = $(`<tbody class="settings"></tbody>`);
                                    for (var j = 0; j < carousels[k].length; j++) {
                                        const id = j;
                                        var lsm = $(`<tr class="row100 body"></tr>`);
                                        var tdDx = $(`<td class="cell100 column4"></td>`);
                                        var dx = $(`<div class="field-customization"></div>`);
                                        dx.dxLookup({
                                            items: dataImages,
                                            searchExpr: ['Nom'],
                                            displayExpr: getDisplayExpr,
                                            dropDownOptions: {
                                              title: "Selection de l'image",
                                            },
                                            valueExpr: 'ID',
                                            value: getIDFromImage(carousels[k][j].img),
                                            fieldTemplate(d) {
                                              return getTemplateMarkup(d, 'custom-field');
                                            },
                                          });

                                          function getIDFromImage(image) {
                                            for(let p=0; p<dataImages.length; p++) {
                                                if(dataImages[p].Image === ("."+image))
                                                    return p;
                                            }
                                            return 0;
                                          }

                                          function getTemplateMarkup(d, containerClass) {
                                            return `<div class='${containerClass}'><img id="carousels_sm_img${k}${id}" src='${
                                              d.Image}' /><div>${d.Nom}</div></div>`;
                                          }

                                          function getDisplayExpr(item) {
                                            if (!item) return '';
                                            return item.Nom;
                                          }
                                        tdDx.append(dx);
                                        lsm.append(tdDx);
                                        lsm.append(`<td class="cell100 column2"><input type="text" id="carousels_sm_titre${k}${id}" value="${carousels[k][j].titre}"></input></td>`);
                                        lsm.append(`<td class="cell100 column2"><input type="text" id="carousels_sm_desc${k}${id}" value="${carousels[k][j].description}"></input></td>`);
                                        lsm.append(`<td class="cell100 column3"><input type="text" id="carousels_sm_lien${k}${id}" value="${carousels[k][j].lien}"></input></td>`);
                                        var maj = $(`<input idcarousels="${k}" id="${id}" type="button" value="Mettre à jour"></input>`);
                                        var tdMaj = $(`<td class="cell100 column5"></td>`);
                                        maj.click(function(e) {
                                            e.preventDefault();
                                            var idcarousels = $( this ).attr("idcarousels");
                                            var id = $( this ).attr("id");
                                            data.carousels[idcarousels][id].img = $("img#carousels_sm_img"+idcarousels+id).attr("src").replace("../", "./");
                                            data.carousels[idcarousels][id].titre = $("input#carousels_sm_titre"+idcarousels+id).val();
                                            data.carousels[idcarousels][id].description = $("input#carousels_sm_desc"+idcarousels+id).val();
                                            data.carousels[idcarousels][id].lien = $("input#carousels_sm_lien"+idcarousels+id).val();
                                            $.ajax({
                                                type : "POST",
                                                url  : "../data/data.php",
                                                data : { function : "updateCarousels", 
                                                         data : { name : pseudo, pwd : mdp,
                                                                  carousels : data.carousels} },
                                                success: function(res){
                                                    gestion_carousels(res);
                                                }
                                            });
                                        });
                                        tdMaj.append(maj);
                                        lsm.append(tdMaj);
                                        var suppr = $(`<input idcarousels="${k}" id="${id}" type="button" value="Supprimer ×"></input>`);
                                        var tdSuppr = $(`<td class="cell100 column5"></td>`);
                                        tdSuppr.append(suppr);
                                        suppr.click(function(e) {
                                            e.preventDefault();
                                            var idcarousels = $( this ).attr("idcarousels");
                                            var id = $( this ).attr("id");
                                            if(confirm("Voulez-vous vraiment supprimer ce lien?\n(" + $("input#carousels_sm_titre"+idcarousels+id).val() + ")")) {
                                                data.carousels[idcarousels].splice(id, 1);
                                                $.ajax({
                                                    type : "POST",
                                                    url  : "../data/data.php",
                                                    data : { function : "updateCarousels", 
                                                             data : { name : pseudo, pwd : mdp,
                                                                      carousels : data.carousels} },
                                                    success: function(res){
                                                        gestion_carousels(res);
                                                    }
                                                });
                                            }
                                        });
                                        lsm.append(tdSuppr);
                                        rsm.append(lsm);
                                    }
                                    tsm.append(rsm);
                                    divScrollSM.append(tsm);
                                    dsm.append(divScrollSM);
                                    var divScrollAddSM = $(`<div class="table100-body js-pscroll">`);
                                    var tAddSM = $(`<table></table>`);
                                    var rAddSM = $(`<tbody class="settings"></tbody>`);
                                    var lAddSM = $(`<tr class="row100 body"></tr>`);
                                    var tdAddDx = $(`<td class="cell100 column4"></td>`);
                                    var dxAdd = $(`<div class="field-customization"></div>`);
                                    dxAdd.dxLookup({
                                        items: dataImages,
                                        searchExpr: ['Nom'],
                                        displayExpr: getDisplayExpr,
                                        dropDownOptions: {
                                          title: "Selection de l'image",
                                        },
                                        valueExpr: 'ID',
                                        value: 0,
                                        fieldTemplate(d) {
                                          return getTemplateMarkup(d, 'custom-field');
                                        },
                                    });

                                    function getIDFromImage(image) {
                                        for(let p=0; p<dataImages.length; p++) {
                                            if(dataImages[p].Image === ("."+image))
                                                return p;
                                        }
                                        return 0;
                                    }

                                    function getTemplateMarkup(d, containerClass) {
                                        return `<div class='${containerClass}'><img id="carousels__ADDLINK__img${k}" src='${
                                          d.Image}' /><div>${d.Nom}</div></div>`;
                                    }

                                    function getDisplayExpr(item) {
                                        if (!item) return '';
                                        return item.Nom;
                                    }
                                    tdAddDx.append(dxAdd);
                                    lAddSM.append(tdAddDx);
                                    lAddSM.append(`<td class="cell100 column2"><input type="text" id="carousels__ADDLINK__titre${k}"></input></td>`);
                                    lAddSM.append(`<td class="cell100 column2"><input type="text" id="carousels__ADDLINK__desc${k}"></input></td>`);
                                    lAddSM.append(`<td class="cell100 column3"><input type="text" id="carousels__ADDLINK__lien${k}"></input></td>`);
                                    var addSM = $(`<input type="button" idcarousels="${k}" value="Ajouter le lien"></input>`);
                                    var tdAddSM = $(`<td class="cell100 column4"></td>`);
                                    addSM.click(function(e) {
                                        e.preventDefault();
                                        var idcarousels = $( this ).attr("idcarousels");
                                        data.carousels[idcarousels].push({img: $("img#carousels__ADDLINK__img"+idcarousels).attr("src").replace("../", "./"),
                                                                          titre: $("input#carousels__ADDLINK__titre"+idcarousels).val(),
                                                                          description: $("input#carousels__ADDLINK__desc"+idcarousels).val(),
                                                                          lien: $("input#carousels__ADDLINK__lien"+idcarousels).val()});
                                        $.ajax({
                                            type : "POST",
                                            url  : "../data/data.php",
                                            data : { function : "updateCarousels", 
                                                     data : { name : pseudo, pwd : mdp,
                                                              carousels : data.carousels} },
                                            success: function(res){
                                                gestion_carousels(res);
                                            }
                                        });
                                    });
                                    tdAddSM.append(addSM);
                                    lAddSM.append(tdAddSM);
                                    lAddSM.append(`<td class="cell100 column5"></td>`);
                                    lAddSM.append(`<td class="cell100 column5"></td>`);
                                    rAddSM.append(lAddSM);
                                    tAddSM.append(rAddSM);
                                    divScrollAddSM.append(tAddSM);
                                    dsm.append(divScrollAddSM);
                                    l.append(dsm);
                                    var suppr = $(`<input idcarousels="${k}" type="button" value="Supprimer ×"></input>`);
                                    var tdSuppr = $(`<td class="cell100 column5"></td>`);
                                    tdSuppr.append(suppr);
                                    suppr.click(function(e) {
                                        e.preventDefault();
                                        var idcarousels = $( this ).attr("idcarousels");
                                        if(confirm("Voulez-vous vraiment supprimer ce carousel?\n(" + idcarousels + ")")) {
                                            delete data.carousels[idcarousels];
                                            $.ajax({
                                                type : "POST",
                                                url  : "../data/data.php",
                                                data : { function : "updateCarousels", 
                                                         data : { name : pseudo, pwd : mdp,
                                                                  carousels : data.carousels} },
                                                success: function(res){
                                                    gestion_carousels(res);
                                                }
                                            });
                                        }
                                    });
                                    l.append(tdSuppr);
                                    r.append(l);
                                }
                                t.append(r);
                                divScroll.append(t);
                                d.append(divScroll);
                                var divScrollAdd = $(`<div class="table100-body js-pscroll">`);
                                var tAdd = $(`<table></table>`);
                                var rAdd = $(`<tbody class="settings"></tbody>`);
                                var lAdd = $(`<tr class="row100 body"></tr>`);
                                lAdd.append(`<td class="cell100 column5"><input type="text" id="nom__ADDCAROUSEL__"></input></td>`);
                                var add = $(`<input type="button" value="Ajouter le carousel"></input>`);
                                var tdAdd = $(`<td class="cell100 column4"></td>`);
                                add.click(function(e) {
                                    e.preventDefault();
                                    data.carousels[$("input#nom__ADDCAROUSEL__").val()] = Array();
                                    $.ajax({
                                        type : "POST",
                                        url  : "../data/data.php",
                                        data : { function : "updateCarousels", 
                                                 data : { name : pseudo, pwd : mdp,
                                                          carousels : data.carousels} },
                                        success: function(res){
                                            gestion_carousels(res);
                                        }
                                    });
                                });
                                tdAdd.append(add);
                                lAdd.append(tdAdd);
                                lAdd.append(`<td class="cell100 column5"></td>`);
                                rAdd.append(lAdd);
                                tAdd.append(rAdd);
                                divScrollAdd.append(tAdd);
                                d.append(divScrollAdd);
                                $("div.contenu").append(d);
                                $("div.contenu").append(`<p id="result"></p>`);
                                if(reponse != 1) {
                                    if(reponse == 0)
                                        $("p#result").empty().show().html(`<p style="color: green;">Données mises à jour.</p>`).delay(3000).fadeOut(300);
                                    else if(reponse == 2)
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur, Le lien existe déjà.</p>`).delay(3000).fadeOut(300);
                                    else
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour des données.</p>`).delay(3000).fadeOut(300);
                                }
                                //Clipboard
                                $(".clipboard").click(function(e) {
                                    navigator.clipboard.writeText(`<div id="${$(this).html()}" class="carousel">Carousel</div>`);
                                });

                            }
                        });
                    }

                    function gestion_images(reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;
                        $.ajax({
                            type : "POST",
                            url  : "../data/data.php",
                            data : { function : "getImages", 
                                     data : { name : pseudo, pwd : mdp }},
                            success: function(res){
                                $("div.contenu").empty();
                                if(res == -1) $("div.contenu").append(`<p>Erreur de connexion à la base de données</p>`);
                                for(let i=0; i< res.length; i++) {
                                    var img = $(`<div id="multicouche">
                                            <a class="gestion_img" idimg="${res[i]}">
                                                <img src="${res[i]}" alt="${res[i]}" title="${res[i]}"></img>
                                                <img id="remove" src="../images/remove.png" alt="remove" title="${res[i]}"></img>
                                            </a>
                                       </div>`);
                                    img.find("a.gestion_img").click(function(e) {
                                        e.preventDefault();
                                        var idimg = $( this ).attr("idimg");
                                        $.ajax({
                                            type : "POST",
                                            url  : "../data/data.php",
                                            data : { function : "removeImage", 
                                                     data : { name : pseudo, pwd : mdp,
                                                              img : idimg} },
                                            success: function(res){
                                                gestion_images(res);
                                            }
                                        });
                                    });
                                    $("div.contenu").append(img);
                                }
                                $("div.contenu").append(`<form id="uploadimg" action="../data/upload.php" method="post" enctype="multipart/form-data">
                                                            <input id="uploadImage" type="file" accept="image/*" name="image" />
                                                            <input id="button" type="submit" value="Ajouter l'image">
                                                         </form>
                                                         <div id="err"></div>`);
                                $("#uploadimg").on('submit',(function(e) {
                                    e.preventDefault();
                                    $('input#button').val("Ajout de l'image...");
                                    $('input#button').attr('disabled','disabled');
                                    //test extension
                                    var re = /(?:\.([^.]+))?$/;
                                    var ext = re.exec($("#uploadimg")[0][0].value)[1];
                                    if(['jpeg', 'jpg', 'png', 'gif', 'bmp'].includes(ext)) {
                                        $.ajax({
                                            url: "../data/upload.php",
                                            type: "POST",
                                            data:  new FormData(this),
                                            contentType: false,
                                                  cache: false,
                                            processData:false,
                                            success: function(data) {
                                                gestion_images(data);
                                            }
                                        });
                                    }
                                    else
                                        gestion_images(-2);
                                }));
                                $("div.contenu").append(`<p id="result"></p>`);
                                if(reponse != 1) {
                                    if(reponse == 0)
                                        $("p#result").empty().show().html(`<p style="color: green;">Image supprimée.</p>`).delay(3000).fadeOut(300);
                                    else if(reponse == 2)
                                        $("p#result").empty().show().html(`<p style="color: green;">Image ajoutée.</p>`).delay(3000).fadeOut(300);
                                    else if(reponse == -2)
                                        $("p#result").empty().show().html(`<p style="color: red;">Fichier invalide!</p>`).delay(3000).fadeOut(300);
                                    else
                                        $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la suppression de l'image.</p>`).delay(3000).fadeOut(300);
                                }
                            }
                        });
                    }

                    function cnfdnclt() {
                        $("div.contenu").empty();
                        $("div.contenu").append(
                        $(`<div>
                               <div class="settings row"><label class="col-3" for="pwd">Ancien mot de passe</label>
                               <input class="col-6" type="password" id="pwd" name="pwd" required minlength="4" size="50"></input></div>
                               <div class="settings row"><label class="col-3" for="new_pwd">Nouveau mot de passe</label>
                               <input class="col-6" type="password" id="new_pwd" name="new_pwd" required minlength="4" size="50"></input></div>
                               <div class="settings row"><div class="col-2"></div><input class="col-2" type="submit" id="submit" value="Mettre à jour" style="width: auto;"><div class="col-8"></div></div>
                               <p id="result"></p>
                           </div>`));
                        $("input#submit").click(function(e) {
                            e.preventDefault();
                            var pwd = $("input#pwd").val();
                            var new_pwd = $("input#new_pwd").val();
                            $("input#pwd").val('');
                            $("input#new_pwd").val('');
                            if(sha256(pwd) == mdp) {
                                $.ajax({
                                    type : "POST",
                                    url  : "../data/data.php",
                                    data : { function : "changePassword", 
                                             data : { name : pseudo, pwd : mdp,
                                                      new_pwd : sha256(new_pwd) } },
                                    success: function(res){
                                        localStorage.setItem("mdp", new_pwd);
                                        mdp = new_pwd;
                                        if(res == 0)
                                            $("p#result").empty().show().html(`<p style="color: green;">Mot de passe mis à jour.</p>`).delay(3000).fadeOut(300);
                                        else
                                            $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour du mot de passe.</p>`).delay(3000).fadeOut(300);
                                    }
                                });
                            }
                            else {
                                $("p#result").empty().show().html(`<p style="color: red;">Ancien mot de passe incorrect.</p>`).delay(3000).fadeOut(300);
                            }
                        });
                    }

                    //Changement de page (après chargement du header)
                    function setChangement() {
                        $("a").click(function(e) {
                            var href = $(this).attr("href");
                            if(href.includes("http") || href.includes(".html") || href.includes("#")) return;
                            //Sauvegarde du nom de la page actuellement visionnée
                            localStorage.setItem("page", href);
                            //Chargement de la page
                            if(href == "__ACCUEIL__") {
                                e.preventDefault();
                                accueil();
                            }
                            else if(href == "__SETTINGS__") {
                                e.preventDefault();
                                settings();
                            }
                            else if(href == "__CNFDNCLT__") {
                                e.preventDefault();
                                cnfdnclt();
                            }
                            else if(href == "__USERS__") {
                                e.preventDefault();
                                users();
                            }
                            else if(href == "__PAGES__") {
                                e.preventDefault();
                                gestion_pages();
                            }
                            else if(href == "__NAVBAR__") {
                                e.preventDefault();
                                gestion_navbar();
                            }
                            else if(href == "__CAROUSELS__") {
                                e.preventDefault();
                                gestion_carousels();
                            }
                            else if(href == "__IMAGES__") {
                                e.preventDefault();
                                gestion_images();
                            }
                            else {
                                e.preventDefault();
                                loadPageWebsite(href);
                            }
                        });
                    }
                    setChangement();

                    function loadPageWebsite(href, reponse) {
                        var reponse = (typeof reponse !== 'undefined') ? reponse : 1;
                        const page = href;
                        $("div.contenu").empty();
                        $("div.contenu").append($(`<input type="text" class="page" id="nom_page" value="${data.pages[href].nom}"></input>`));
                        $("div.contenu").append($(`<textarea id="tiny"></textarea>`));
                        //Initialisation de tinymce:
                        tinymce.remove("textarea#tiny");
                        tinymce.init({
                            selector: 'textarea#tiny',
                            setup: function (editor) {
                              editor.on('init', function (e) {
                                //Chargement des données de tinymce:
                                editor.setContent(data.pages[href].contenu);
                                $("div.tox-tinymce").addClass('page');
                              });
                            },
                            language: 'fr_FR',
                            height: 400,
                            min_height: 200,
                            entity_encoding: 'raw',
                            plugins: 'searchreplace autolink code image media link hr anchor lists paste',
                            toolbar: 'formatselect | bold italic underline strikethrough forecolor | link image media | alignleft aligncenter alignright alignjustify | bullist numlist | removeformat code | undo redo',
                            relative_urls : false,

                            automatic_uploads: true,
                            paste_data_images: true,
                            file_picker_types: 'image media',

                            images_upload_handler: function (blobInfo, success, failure) {
                                var xhr, formData;

                                xhr = new XMLHttpRequest();
                                xhr.withCredentials = false;
                                xhr.open('POST', 'upload.php');

                                xhr.onload = function() {

                                if (xhr.status != 200) {
                                    failure('HTTP Error: ' + xhr.status);
                                    return;
                                }

                                success(xhr.response);
                                };

                                formData = new FormData();
                                formData.append('file', blobInfo.blob(), blobInfo.filename());

                                xhr.send(formData);
                            }
                        });
                        document.title = data.pages[href].nom;
                        var add = $(`<input class="page" type="button" value="Mettre à jour"></input>`);
                        add.click(function(e) {
                            e.preventDefault();
                            data.pages[page].nom = $("input#nom_page").val();
                            data.pages[page].contenu = tinyMCE.activeEditor.getContent();
                            $.ajax({
                                type : "POST",
                                url  : "../data/data.php",
                                data : { function : "updateCarousels", 
                                         data : { name : pseudo, pwd : mdp,
                                                  carousels : data.carousels} },
                                success: function(res){
                                    loadPageWebsite(page, res);
                                }
                            });
                        });
                        $("div.contenu").append(add);
                        //Remonte en haut de page
                        document.body.scrollTop = 0;
                        document.documentElement.scrollTop = 0;
                        //Initialisation du carousel (si il y en a un)
                        initCarousel();
                        //Reset des liens de la page
                        $("a").unbind('click');
                        setChangement();
                        $("div.contenu").append(`<p id="result"></p>`);
                        if(reponse != 1) {
                            if(reponse == 0)
                                $("p#result").empty().show().html(`<p style="color: green;">Page éditée.</p>`).delay(3000).fadeOut(300);
                            else
                                $("p#result").empty().show().html(`<p style="color: red;">Erreur dans la mise à jour de la page.</p>`).delay(3000).fadeOut(300);
                        }
                    }

                    function initCarousel() {
                        //Initialisation WOW js
                        new WOW().init();

                        //Démarrage Services carousel
                        $("#services-carousel").owlCarousel({
                            navigation: false,
                            pagination: true,
                            slideSpeed: 800,
                            paginationSpeed: 800,
                            smartSpeed: 500,
                            autoplay: true,
                            singleItem: true,
                            loop: true,
                            responsive:{
                                0:{
                                    items:1
                                },
                                680:{
                                    items:2
                                },
                                1000:{
                                    items:3
                                }
                            }
                        });
                    }
                    initCarousel();
                }
            });
        }
        loadData(refPage);

        //dropdown menu
        $(".dropdown").hover(function(){
            var dropdownMenu = $(this).children(".dropdown-menu");
            if(dropdownMenu.is(":visible")){
                dropdownMenu.parent().toggleClass("open");
            }
        });

        //Sidebar menu
        var sidenav = document.getElementById("sidenav");
        var openBtn = document.getElementById("openBtn");
        var closeBtn = document.getElementById("closeBtn");

        openBtn.onclick = openNav;
        closeBtn.onclick = closeNav;

        /* Set the width of the side navigation to 250px */
        function openNav(e) {
            e.preventDefault();
            sidenav.classList.add("active");
            openBtn.classList.remove("burger");
        }

        /* Set the width of the side navigation to 0 */
        function closeNav(e) {
            e.preventDefault();
            sidenav.classList.remove("active");
            openBtn.classList.add("burger");
        }

        //Cacher la sidenav en cas de clic extérieur
        $(window).click(function (e) {
            var t = e.target;
            if(t != sidenav && 
               t != openBtn && 
               t != $(".burger-center")[0] && 
               t != $(".icon-bar")[0] && 
               t != $(".icon-bar")[1] && 
               t != $(".icon-bar")[2]) {
                sidenav.classList.remove("active");
                openBtn.classList.add("burger");
            }
         });
        }
    });

//On cache les scripts JS utilisés par sécurité
$("div.scripts").remove();