<?php

// Polyfill for PHP 4 - PHP 7, safe to utilize with PHP 8
if (!function_exists('str_contains')) {
    function str_contains($haystack, $needle) {
        return $needle !== '' && mb_strpos($haystack, $needle) !== false;
    }
}

function get_index($list, $val) {
	for($i=0; $i<count($list); $i++) {
		if($list[$i] == $val) return $i;
	}
	return -1;
}

$function = $_POST["function"];
$vuesAdmin = $_POST["admin"];
$file = "analytics.json";
$file_data = file_get_contents($file);
if (str_contains($function, 'getVues')) {
	header('Content-Type: application/json; charset=utf-8');
	echo $file_data;
}
else {
	$mois = ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'];

	$tmp = json_decode($file_data, true);
	$analytics['jours'] = Array();
    for($i=6; $i>=0; $i--) {
        $date = new DateTime($i . ' days ago');
        $analytics['jours'][6-$i] = $date->format('j ') . $mois[$date->format('n')] . $date->format(' Y');
    }
	for($i=0; $i<7; $i++) { //Jours précédents:
		$j = get_index($analytics['jours'], $tmp['jours'][$i]);
		if($j != -1) {
			$analytics['vuesAdmin'][$j] = $tmp['vuesAdmin'][$i];
			$analytics['vues'][$j] = $tmp['vues'][$i];
		}
		else {
			$analytics['vuesAdmin'][$i] = 0;
			$analytics['vues'][$i] = 0;
		}
	}
	//Jour actuel:
	if($vuesAdmin) $analytics['vuesAdmin'][6] += 1;
	else $analytics['vues'][6] += 1;
	$new_data = json_encode($analytics);
	$fp = fopen($file, 'w');
	fwrite($fp, $new_data);
	fclose($fp);
	$file_data = file_get_contents($file);
	header('Content-Type: application/json; charset=utf-8');
	echo $file_data;
}
?>
