<?php
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
	// Polyfill for PHP 4 - PHP 7, safe to utilize with PHP 8
	if (!function_exists('str_contains')) {
	    function str_contains($haystack, $needle) {
	        return $needle !== '' && mb_strpos($haystack, $needle) !== false;
	    }
	}
	//Delete Directory
	function deleteDir($dirPath) {
	    if (! is_dir($dirPath)) {
	        throw new InvalidArgumentException("$dirPath must be a directory");
	    }
	    if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
	        $dirPath .= '/';
	    }
	    $files = glob($dirPath . '*', GLOB_MARK);
	    foreach ($files as $file) {
	        if (is_dir($file)) {
	            deleteDir($file);
	        } else {
	            unlink($file);
	        }
	    }
	    rmdir($dirPath);
	}

	umask(0);//Reset umask

	$msg = "";
	$id = -1;

	if(isset($_POST["function"])) {
		$function = $_POST["function"];
		if (str_contains($function, 'updateCMS')) {
			if(intval(substr(sprintf('%o', fileperms('./')), -3)) >= 775) {
				$opts = array('http'=>array('header' => "User-Agent:MyAgent/1.0\r\n"));
				$context = stream_context_create($opts);

				$urlUpdate = 'https://dev.crystalium.eu/light-cms/update.php';
				$data = array('function' => 'getURL');

				// use key 'http' even if you send the request to https://...
				$options = array(
				    'http' => array(
				        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				        'method'  => 'POST',
				        'content' => http_build_query($data)
				    )
				);
				$context  = stream_context_create($options);
				$result = file_get_contents($urlUpdate, false, $context);
				if ($result === FALSE) { $msg = "Can't access to zip url, try again later."; }
				else {
					$url = $result;

					$data = array('function' => 'getMD5');

					// use key 'http' even if you send the request to https://...
					$options = array(
					    'http' => array(
					        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					        'method'  => 'POST',
					        'content' => http_build_query($data)
					    )
					);
					$context  = stream_context_create($options);
					$result = file_get_contents($urlUpdate, false, $context);
					if ($result === FALSE) { $msg = "Can't access to md5, try again later."; }
					else {
						$md5 = $result;

						$dir = __DIR__ . "/tmp"; // Full path
						$file_name = 'tmp/' . basename($url);

						$boss = posix_getpwuid(posix_geteuid())['name'];
						$uf = posix_getpwuid(fileowner('./'))['name'];
						$gf = posix_getpwuid(filegroup('./'))['name'];

						if((strcmp($boss, $uf) == 0) || (strcmp($boss, $gf) == 0)) {
							if(is_dir($dir) || @mkdir($dir)) {
								if(file_put_contents($file_name, file_get_contents($url))) {
									if(strcmp(md5_file($file_name), $md5) == 0) {
										$zip = new ZipArchive;
										if ($zip->open($file_name) === TRUE) {
										    $zip->extractTo('../');
										    $zip->close();
										    deleteDir($dir);
										    $msg = 'CMS updated successfully.';
										    $id = 0;
										} else {
										    $msg = 'Unzip failed.';
										}
									}
									else {
										$msg = 'Wrong md5.';
									}
								} else {
									$msg = 'File downloading failed.';
								}
							}
							else {
								$msg = "Can't create folder tmp."; 
							}
						}
						else {
							$msg = 'Set main folder owner to php executable user (default: www-data).';
						}
					}
				}
			}
			else {
				$msg = 'Set main folder permissions to 770 minimum.';
			}
		}
	}

	header('Content-Type: application/json; charset=utf-8');
	echo json_encode(array("ID"=>$id, "Message"=>$msg));
?>