
import { MD5 } from './md5.js';

$(document).ready(function() {
    $.ajax({
        type : "POST",
        url  : "./data/analytics.php"
    });

    //Chargement des données
    $.ajax({
        type : "POST",
        url  : "./data/data.php",
        data : { function : "getDB" },
        success: function(data){
            //Chargement des metadatas
            $("meta[name='description']").attr("content", data.description);
            $("meta[name='keywords']").attr("content", data.keywords);
            document.title = data.pages.index.nom;
            //Chargement du logo
            $("a.navbar-brand").append($('<img class="img-fluid" src="'+data.logo+'" alt="Radio Vintage">'));
            //Chargement de la page (index par défaut)
            $("div.contenu").append($(data.pages.index.contenu));
            //Chargement des liens du header
            var liensHeader = data.liensHeader;
            liensHeader.sort(function (x, y) {
                return x.pos - y.pos;
            });
            var ul = $("ul.navbar-right");
            var ul2 = $("ul.sidenav-right");
            for (var i = 0; i < liensHeader.length; i++) {
                if(!liensHeader[i].hasOwnProperty("sousMenu")) liensHeader[i]["sousMenu"] = Array();
                var sm = liensHeader[i].sousMenu;
                sm.sort(function (x, y) {
                    return x.pos - y.pos;
                });
                if(sm.length == 0) {
                    var element = $('<li><a class="smooth-menu" href="'+ liensHeader[i].lien +'">'+ liensHeader[i].nom +'</a></li>');
                }
                else {
                    var element = $('<li class="dropdown"><a class="smooth-menu dropdown-toggle" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" href="'+ liensHeader[i].lien +'">'+ liensHeader[i].nom +'</a></li>');
                    var elementSM = $('<div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">');
                    for (var j = 0; j < sm.length; j++) {
                        elementSM.append($('<a class="dropdown-item smooth-menu" href="'+ sm[j].lien +'">'+ sm[j].nom +'</a>'));
                    }
                    element.append(elementSM);
                }
                ul.append(element);
                ul2.append(element.clone());
            }
            //Chargement des liens du footer
            var liensFooter = data.liensFooter;
            liensFooter.sort(function (x, y) {
                return x.pos - y.pos;
            });
            var div = $("div.liensFooter");
            for (var i = 0; i < liensFooter.length; i++) {
                var element = $('<div class="col-12 col-xs-6 col-sm-6 col-md-2 col-lg-2"><a class="smooth-menu" href="'+ liensFooter[i].lien +'">'+ liensFooter[i].nom +'</a></div>');
                div.append(element);
            }
            //Chargement du footer
            $("div.footer").empty().append(`<p>${data.footer}</p>`);

            //Rajout des carousels
            function ajoutCarousels() {
                for (let key of Object.keys(data.carousels)) {
                    var row = $(`<div class="row"></div>`);
                    var services = $(`<div id="services-carousel" class="owl-carousel owl-theme"></div>`);
                    for(var i=0; i<data.carousels[key].length; i++) {
                        if(data.carousels[key][i].lien == "")
                            var e = $(`<div class="single-services text-center item"></div>`);
                        else
                            var e = $(`<a class="single-services text-center item" href="` + data.carousels[key][i].lien + `"></a>`);
                        e.append($(`<div class="services-icon"><img src="` + data.carousels[key][i].img + `" alt="` + data.carousels[key][i].titre + `"/></div>`));
                        e.append($(`<div class="services-content"><h3>` + data.carousels[key][i].titre + `</h3><p>` + data.carousels[key][i].description + `</p></div>`));
                        services.append(e);
                    }
                    row.append(services);
                    $("div.carousel#"+key).replaceWith(row);
                }
            }

            function initCarousel() {
                //Initialisation WOW js
                new WOW().init();

                //Démarrage Services carousel
                $(".owl-carousel").owlCarousel({
                    navigation: false,
                    pagination: true,
                    slideSpeed: 800,
                    paginationSpeed: 800,
                    smartSpeed: 500,
                    autoplay: true,
                    singleItem: true,
                    loop: true,
                    responsive:{
                        0:{
                            items:1
                        },
                        680:{
                            items:2
                        },
                        1000:{
                            items:3
                        }
                    }
                });
            }

            //Changement de page (après chargement du header et des carousels)
            function setChangement() {
                $("a").click(function(e) {
                    var href = $(this).attr("href");
                    if(!(href.includes("http") || href.includes("#"))) {
                        e.preventDefault();

                        $("div.contenu").empty();
                        $("div.contenu").append($(data.pages[href].contenu));
                        document.title = data.pages[href].nom;
                        //Remonte en haut de page
                        document.body.scrollTop = 0;
                        document.documentElement.scrollTop = 0;
                        //Initialisation du carousel (si il y en a un)
                        ajoutCarousels();
                        initCarousel();
                        //Reset des liens de la page
                        $("a").unbind('click');
                        setChangement();
                    }
                });
            }
            ajoutCarousels();
            initCarousel();
            setChangement();
        }
    });

    //dropdown menu
    $(".dropdown").hover(function(){
        var dropdownMenu = $(this).children(".dropdown-menu");
        if(dropdownMenu.is(":visible")){
            dropdownMenu.parent().toggleClass("open");
        }
    });

    //Sidebar menu
    var sidenav = document.getElementById("sidenav");
    var openBtn = document.getElementById("openBtn");
    var closeBtn = document.getElementById("closeBtn");

    openBtn.onclick = openNav;
    closeBtn.onclick = closeNav;

    /* Set the width of the side navigation to 250px */
    function openNav(e) {
        e.preventDefault();
        sidenav.classList.add("active");
        openBtn.classList.remove("burger");
    }

    /* Set the width of the side navigation to 0 */
    function closeNav(e) {
        e.preventDefault();
        sidenav.classList.remove("active");
        openBtn.classList.add("burger");
    }

    //Supprimer la sidenav au redimensionnement de la fenêtre
    $(window).resize(function() {
        if($(window).width() >= 1180) {
            sidenav.classList.remove("active");
            openBtn.classList.add("burger");
        }
    });

    //Cacher la sidenav en cas de clic extérieur
    $(window).click(function (e) {
        var t = e.target;
        if(t != sidenav && 
           t != openBtn && 
           t != $(".burger-center")[0] && 
           t != $(".icon-bar")[0] && 
           t != $(".icon-bar")[1] && 
           t != $(".icon-bar")[2]) {
            sidenav.classList.remove("active");
            openBtn.classList.add("burger");
        }
     });
});

//On cache les scripts JS utilisés par sécurité
$("div.scripts").remove();