//Style pour Google Chrome
if (navigator.userAgentData?.brands?.some(b => b.brand === 'Google Chrome'))
    document.getElementById("volume").style.border = "1px solid #242424";

//var player = document.getElementById("player-audio");
var play = document.getElementById("play");
var sync = document.getElementById("sync");
var mute = document.getElementById("mute");
var spectre = document.getElementById("spectre");
var volume = document.getElementById("volume");
//var current = document.getElementById("current");
$.ajax({
    type : "POST",
    url  : "./data/data.php",
    data : { function : "getURLPlayer" },
    success: function(url){
        var player = new Audio(url);
        player.addEventListener('loadeddata', () => {
            player.volume = volume.value;
        })
        resetVolume(); //Initialise le volume

        var playpause = function() {
            if(player.paused) {
                player.play();
            }
            else {
                player.pause();
            }
        }

        var syncplayer = function() {
            if(player.paused) {
                player.load();
                player.pause();
            }
            else {
                player.load();
                player.play();
            }
        }

        play.addEventListener("click", playpause);
        sync.addEventListener("click", syncplayer);
        player.onplay = function() {
            play.classList.remove("fa-play");
            play.classList.add("fa-pause");
            spectre.classList.remove("pause");
            spectre.classList.add("playing");
        }
        player.onpause = function() {
            play.classList.add("fa-play");
            play.classList.remove("fa-pause");
            spectre.classList.add("pause");
            spectre.classList.remove("playing");
        }

        function formatTime(seconds) {
            minutes = Math.floor(seconds / 60);
            seconds = Math.floor(seconds % 60);
            seconds = (seconds >= 10) ? seconds : "0" + seconds;
            return minutes + ":" + seconds;
        }
        /*
        player.ontimeupdate = function() {
            current.innerHTML = formatTime(player.currentTime);

        }
        */

        mute.addEventListener("click", function(e, ui) {
            var icon = mute.children[0];
            if(player.muted) {
                player.muted = false;
                icon.classList.add("fa-volume-up");
                icon.classList.remove("fa-volume-mute");
            }
            else {
                player.muted = true;
                icon.classList.remove("fa-volume-up");
                icon.classList.add("fa-volume-mute");
            }
        });

        volume.ondblclick = function(e, ui) {
            resetVolume();
        };

        volume.onchange = function(e, ui) {
            changeVolume(e.target.value);
        };

        volume.oninput = function(e, ui) {
            changeVolume(e.target.value);
        };

        function changeVolume(amount) {
            if(player.readyState >= 2 /*HAVE_CURRENT_DATA*/)
                player.volume = amount;
        }

        function resetVolume() {
            volume.value = 0.5;
            if(player.readyState >= 2 /*HAVE_CURRENT_DATA*/)
                player.volume = volume.value;
        }
    }
});