<?php $__env->startSection('content'); ?>
    <?php if($compatible): ?>
        <p><?php echo app('translator')->get('install.welcome'); ?></p>

        <div class="text-center">
            <p class="text-success">
                <i class="fas fa-check"></i> <?php echo e(trans('install.requirements.success')); ?>

            </p>

            <a href="<?php echo e(route('install.database')); ?>" class="btn btn-primary rounded-pill mx-1">
                <?php echo e(trans('messages.actions.continue')); ?> <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    <?php else: ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo e(trans('install.requirements.missing')); ?>

        </div>

        <div class="list-group mb-3 requirements">
            <?php $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement => $requirementStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="list-group-item">
                    <div class="row">
                        <div class="col-10">
                            <?php if(Str::startsWith($requirement, 'extension-')): ?>
                                <?php echo app('translator')->get('install.requirements.extension', ['extension' => Str::after($requirement, '-')]); ?>
                            <?php elseif(Str::startsWith($requirement, 'function-')): ?>
                                <?php echo app('translator')->get('install.requirements.function', ['function' => Str::after($requirement, '-')]); ?>
                            <?php else: ?>
                                <?php echo app('translator')->get('install.requirements.'.$requirement, ['version' => $minPhpVersion]); ?>
                            <?php endif; ?>
                        </div>

                        <div class="col-2">
                            <?php if($requirement === 'php'): ?>
                                <span class="float-right text-<?php echo e($requirementStatus ? 'success' : 'danger'); ?>"
                                      title="<?php echo e(PHP_VERSION); ?>">
                                    <?php echo e($phpVersion); ?>

                                </span>
                            <?php elseif($requirementStatus): ?>
                                <i class="fas fa-check text-success float-right"></i>
                            <?php else: ?>
                                <i class="fas fa-times text-danger float-right"></i>
                            <?php endif; ?>
                        </div>

                        <?php if(!$requirementStatus): ?>
                            <div class="col-md-12 px-4 mt-2">
                                <i class="fas fa-info-circle text-primary mr-1"></i>
                                <?php if(Str::startsWith($requirement, 'extension-')): ?>
                                    <?php echo app('translator')->get('install.requirements.extension', [
                                        'command' => "apt install curl php${v}-mysql php${v}-pgsql php${v}-sqlite php${v}-bcmath php${v}-mbstring php${v}-xml php${v}-curl php${v}-zip php${v}-gd",
                                    ]); ?>
                                <?php elseif(Str::startsWith($requirement, 'function-')): ?>
                                    <?php echo app('translator')->get('install.requirements.help.function'); ?>
                                <?php elseif($requirement === 'writable'): ?>
                                    <?php echo app('translator')->get('install.requirements.help.writable', ['command' => "chmod -R 755 ${base} && chown -R www-data:www-data ${base}"]); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('install.requirements.help.'.$requirement); ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="text-center">
            <a href="<?php echo e(route('home')); ?>" class="btn btn-primary mx-1">
                <?php echo e(trans('install.requirements.refresh')); ?> <i class="fas fa-redo"></i>
            </a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('install.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/dev/radio/resources/views/install/index.blade.php ENDPATH**/ ?>